/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.breakpoints;

import com.aptana.ruby.debug.core.RubyDebugModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public abstract class RubyBreakpoint
extends Breakpoint {
    protected static final String EXPIRED = "com.aptana.ruby.debug.core.expired";
    protected static final String HIT_COUNT = "com.aptana.ruby.debug.core.hitCount";
    protected static final String TYPE_NAME = "com.aptana.ruby.debug.core.typeName";
    protected static final String INSTALL_COUNT = "com.aptana.ruby.debug.core.installCount";
    protected String fInstalledTypeName = null;

    protected void setTypeName(String typeName) throws CoreException {
        this.setAttribute(TYPE_NAME, typeName);
    }

    public String getTypeName() throws CoreException {
        if (this.fInstalledTypeName == null) {
            return this.ensureMarker().getAttribute(TYPE_NAME, null);
        }
        return this.fInstalledTypeName;
    }

    public String getModelIdentifier() {
        return RubyDebugModel.getModelIdentifier();
    }

    protected void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0) > 0;
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_COUNT, -1);
    }

    public void setHitCount(int count) throws CoreException {
        if (this.getHitCount() != count) {
            if (!this.isEnabled() && count > -1) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", HIT_COUNT, EXPIRED}, new Object[]{Boolean.TRUE, new Integer(count), Boolean.FALSE});
            } else {
                this.setAttributes(new String[]{HIT_COUNT, EXPIRED}, new Object[]{new Integer(count), Boolean.FALSE});
            }
            this.recreate();
        }
    }

    protected void recreate() {
    }
}

